/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.name;

import club.sk1er.patcher.Patcher;
import gg.essential.api.EssentialAPI;
import gg.essential.api.utils.Multithreading;
import gg.essential.api.utils.mojang.Name;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class NameFetcher {
    private final List<String> names = new ArrayList<String>();
    private final DateFormat format = new SimpleDateFormat("MM/dd/yyyy");
    private UUID uuid = null;
    private String name = null;

    public void execute(String username) {
        this.execute(username, true);
    }

    public void execute(String username, boolean async) {
        try {
            if (username.isEmpty()) {
                return;
            }
            Runnable fetchNames = () -> {
                this.name = username;
                this.uuid = null;
                try {
                    CompletableFuture uuid = EssentialAPI.getMojangAPI().getUUID(username);
                    if (uuid == null) {
                        return;
                    }
                    this.uuid = (UUID)uuid.get();
                }
                catch (Exception e) {
                    Patcher.instance.getLogger().warn("Failed fetching UUID.", (Throwable)e);
                    return;
                }
                this.names.clear();
                if (this.uuid != null) {
                    List nameHistory = EssentialAPI.getMojangAPI().getNameHistory(this.uuid);
                    if (nameHistory == null || nameHistory.isEmpty()) {
                        return;
                    }
                    this.name = ((Name)nameHistory.get(nameHistory.size() - 1)).getName();
                    for (Name history : nameHistory) {
                        String name = history.getName();
                        if (history.getChangedToAt() == 0L) {
                            this.names.add(name);
                            continue;
                        }
                        this.names.add(String.format("%s \u00bb %s", name, this.format.format(history.getChangedToAt())));
                    }
                } else {
                    this.names.add("Failed to fetch " + username + "'s names");
                }
            };
            if (async) {
                Multithreading.runAsync((Runnable)fetchNames);
            } else {
                fetchNames.run();
            }
        }
        catch (Exception e) {
            Patcher.instance.getLogger().warn("User catch failed, tried fetching {}.", (Object)username, (Object)e);
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }
}

